/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.init;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import untamedwilds.block.AlgaeBlock;
import untamedwilds.block.AnemoneBlock;
import untamedwilds.block.CageBlock;
import untamedwilds.block.CarpetBlock;
import untamedwilds.block.CritterBurrowBlock;
import untamedwilds.block.CustomGrassBlock;
import untamedwilds.block.EpyphitePlantBlock;
import untamedwilds.block.FloatingPlantBlock;
import untamedwilds.block.LardBlock;
import untamedwilds.block.ReedBlock;
import untamedwilds.block.TallPlantBlock;
import untamedwilds.block.TitanArumBlock;
import untamedwilds.block.UndergrowthBlock;
import untamedwilds.block.UndergrowthPoisonousBlock;
import untamedwilds.block.blockentity.CageBlockEntity;
import untamedwilds.block.blockentity.CritterBurrowBlockEntity;
import untamedwilds.init.ModItems;

@Mod.EventBusSubscriber(modid="untamedwilds", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlock {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"untamedwilds");
    public static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"untamedwilds");
    private static final List<Pair<RegistryObject<Block>, String>> RENDER_TYPE_DATA = Lists.newArrayList();
    public static RegistryObject<Block> CARPET_STRAW = ModBlock.createBlock("carpet_straw", () -> new CarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76400_).m_155954_(0.1f).m_60918_(SoundType.f_56758_)), CreativeModeTab.f_40750_);
    public static RegistryObject<Block> CARPET_BEAR_ASHEN = ModBlock.createBlock("carpet_bear_ashen", () -> new CarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76419_).m_155954_(0.1f).m_60918_(SoundType.f_56745_)), CreativeModeTab.f_40750_);
    public static RegistryObject<Block> CARPET_BEAR_BLACK = ModBlock.createBlock("carpet_bear_black", () -> new CarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76365_).m_155954_(0.1f).m_60918_(SoundType.f_56745_)), CreativeModeTab.f_40750_);
    public static RegistryObject<Block> CARPET_BEAR_BROWN = ModBlock.createBlock("carpet_bear_brown", () -> new CarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76362_).m_155954_(0.1f).m_60918_(SoundType.f_56745_)), CreativeModeTab.f_40750_);
    public static RegistryObject<Block> CARPET_BEAR_WHITE = ModBlock.createBlock("carpet_bear_white", () -> new CarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76406_).m_155954_(0.1f).m_60918_(SoundType.f_56745_)), CreativeModeTab.f_40750_);
    public static RegistryObject<Block> CARPET_BIGCAT_JAGUAR = ModBlock.createBlock("carpet_bigcat_jaguar", () -> new CarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76366_).m_155954_(0.1f).m_60918_(SoundType.f_56745_)), CreativeModeTab.f_40750_);
    public static RegistryObject<Block> CARPET_BIGCAT_LEOPARD = ModBlock.createBlock("carpet_bigcat_leopard", () -> new CarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76366_).m_155954_(0.1f).m_60918_(SoundType.f_56745_)), CreativeModeTab.f_40750_);
    public static RegistryObject<Block> CARPET_BIGCAT_LION = ModBlock.createBlock("carpet_bigcat_lion", () -> new CarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76362_).m_155954_(0.1f).m_60918_(SoundType.f_56745_)), CreativeModeTab.f_40750_);
    public static RegistryObject<Block> CARPET_BIGCAT_PANTHER = ModBlock.createBlock("carpet_bigcat_panther", () -> new CarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76406_).m_155954_(0.1f).m_60918_(SoundType.f_56745_)), CreativeModeTab.f_40750_);
    public static RegistryObject<Block> CARPET_BIGCAT_PUMA = ModBlock.createBlock("carpet_bigcat_puma", () -> new CarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76419_).m_155954_(0.1f).m_60918_(SoundType.f_56745_)), CreativeModeTab.f_40750_);
    public static RegistryObject<Block> CARPET_BIGCAT_SNOW = ModBlock.createBlock("carpet_bigcat_snow_leopard", () -> new CarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76365_).m_155954_(0.1f).m_60918_(SoundType.f_56745_)), CreativeModeTab.f_40750_);
    public static RegistryObject<Block> CARPET_BIGCAT_TIGER = ModBlock.createBlock("carpet_bigcat_tiger", () -> new CarpetBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76362_).m_155954_(0.1f).m_60918_(SoundType.f_56745_)), CreativeModeTab.f_40750_);
    public static RegistryObject<Block> LARD_BLOCK = ModBlock.createBlock("block_lard", () -> new LardBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76313_, (MaterialColor)MaterialColor.f_76416_).m_155954_(0.1f).m_60918_(SoundType.f_56750_)), CreativeModeTab.f_40749_);
    public static RegistryObject<Block> PEARL_BLOCK = ModBlock.createBlock("block_pearl", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76421_).m_155954_(5.0f).m_60918_(SoundType.f_56742_)), CreativeModeTab.f_40749_);
    public static RegistryObject<Block> TRAP_CAGE = ModBlock.createBlock("trap_cage", () -> new CageBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_155954_(3.0f).m_60918_(SoundType.f_56736_)), CreativeModeTab.f_40752_);
    public static RegistryObject<Block> ANEMONE_ROSE_BULB = ModBlock.createBlock("anemone_rose_bulb", () -> new AnemoneBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76301_, (MaterialColor)MaterialColor.f_76364_).m_155954_(0.1f).m_60918_(SoundType.f_56750_)), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> ANEMONE_SAND = ModBlock.createBlock("anemone_sand", () -> new AnemoneBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76301_, (MaterialColor)MaterialColor.f_76418_).m_155954_(0.1f).m_60918_(SoundType.f_56750_)), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> ANEMONE_SEBAE = ModBlock.createBlock("anemone_sebae", () -> new AnemoneBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76301_, (MaterialColor)MaterialColor.f_76372_).m_155954_(0.1f).m_60918_(SoundType.f_56750_)), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> COMMON_REED = ModBlock.createBlock("flora_common_reed", () -> new ReedBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76363_).m_155954_(0.1f).m_60918_(SoundType.f_56760_).m_60910_()), "cutout", CreativeModeTab.f_40750_, 100);
    public static RegistryObject<Block> BUSH_TEMPERATE = ModBlock.createBlock("flora_bush_temperate", () -> new UndergrowthBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76363_).m_155954_(1.0f).m_60918_(SoundType.f_154674_).m_60910_()), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> ELEPHANT_EAR = ModBlock.createBlock("flora_elephant_ear", () -> new UndergrowthBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76363_).m_155954_(1.0f).m_60918_(SoundType.f_56752_).m_60910_(), BlockBehaviour.OffsetType.XYZ), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> HEMLOCK = ModBlock.createBlock("flora_hemlock", () -> new UndergrowthPoisonousBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76363_).m_155954_(0.1f).m_60918_(SoundType.f_56740_).m_60910_(), BlockBehaviour.OffsetType.XYZ), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> YARROW = ModBlock.createBlock("flora_yarrow", () -> new CustomGrassBlock(MobEffects.f_19605_, 4, BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76363_).m_155954_(0.0f).m_60918_(SoundType.f_56740_).m_60910_()), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> JUNEGRASS = ModBlock.createBlock("flora_junegrass", () -> new CustomGrassBlock(MobEffects.f_19590_, 4, BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76363_).m_155954_(0.0f).m_60918_(SoundType.f_56740_).m_60910_()), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> ZIMBABWE_ALOE = ModBlock.createItemlessBlock("flora_zimbabwe_aloe", () -> new TallPlantBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76363_).m_155954_(1.0f).m_60918_(SoundType.f_56736_).m_60988_()), "cutout");
    public static RegistryObject<Block> WATER_HYACINTH = ModBlock.createItemlessBlock("flora_water_hyacinth", () -> new FloatingPlantBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76363_).m_155954_(0.0f).m_60918_(SoundType.f_56741_).m_60910_()), "cutout");
    public static RegistryObject<Block> AMAZON_SWORD = ModBlock.createBlock("flora_amazon_sword", () -> new AlgaeBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76363_).m_155954_(0.0f).m_60918_(SoundType.f_56752_).m_60910_()), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> EELGRASS = ModBlock.createBlock("flora_eelgrass", () -> new AlgaeBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76363_).m_155954_(0.0f).m_60918_(SoundType.f_56752_).m_60910_()), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> ORCHID_MAGENTA = ModBlock.createBlock("flora_orchid_magenta", () -> new EpyphitePlantBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76414_).m_155954_(0.0f).m_60918_(SoundType.f_56760_)), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> ORCHID_PURPLE = ModBlock.createBlock("flora_orchid_purple", () -> new EpyphitePlantBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76422_).m_155954_(0.0f).m_60918_(SoundType.f_56760_)), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> ORCHID_PINK = ModBlock.createBlock("flora_orchid_pink", () -> new EpyphitePlantBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76418_).m_155954_(0.0f).m_60918_(SoundType.f_56760_)), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> ORCHID_RED = ModBlock.createBlock("flora_orchid_red", () -> new EpyphitePlantBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76364_).m_155954_(0.0f).m_60918_(SoundType.f_56760_)), "cutout", CreativeModeTab.f_40750_);
    public static RegistryObject<Block> TITAN_ARUM = ModBlock.createItemlessBlock("flora_titan_arum", () -> new TitanArumBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76363_).m_155954_(2.0f).m_60918_(SoundType.f_56752_).m_60910_().m_60988_()), "cutout");
    public static RegistryObject<Block> BURROW = ModBlock.createBlock("block_burrow", () -> new CritterBurrowBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)MaterialColor.f_76408_).m_155954_(1.0f).m_60918_(SoundType.f_56739_).m_60910_()), "translucent", CreativeModeTab.f_40750_);
    public static final RegistryObject<BlockEntityType<CageBlockEntity>> TILE_ENTITY_CAGE = TILE_ENTITIES.register("trap_cage", () -> BlockEntityType.Builder.m_155273_(CageBlockEntity::new, (Block[])new Block[]{(Block)TRAP_CAGE.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<CritterBurrowBlockEntity>> TILE_ENTITY_BURROW = TILE_ENTITIES.register("critter_burrow", () -> BlockEntityType.Builder.m_155273_(CritterBurrowBlockEntity::new, (Block[])new Block[]{(Block)BURROW.get()}).m_58966_(null));

    public static <B extends Block> RegistryObject<Block> createBlock(String name, Supplier<? extends B> supplier, CreativeModeTab group) {
        return ModBlock.createBlock(name, supplier, null, group, 0);
    }

    public static <B extends Block> RegistryObject<Block> createBlock(String name, Supplier<? extends B> supplier, @Nullable String renderType, CreativeModeTab group) {
        return ModBlock.createBlock(name, supplier, renderType, group, 0);
    }

    public static <B extends Block> RegistryObject<Block> createBlock(String name, Supplier<? extends B> supplier, @Nullable String renderType, CreativeModeTab group, final int burnTime) {
        RegistryObject block = BLOCKS.register(name, supplier);
        if (renderType != null) {
            RENDER_TYPE_DATA.add((Pair<RegistryObject<Block>, String>)new Pair((Object)block, (Object)renderType));
        }
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(group)){

            public int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
                return burnTime;
            }
        });
        return block;
    }

    public static <B extends Block> RegistryObject<Block> createItemlessBlock(String name, Supplier<? extends B> supplier) {
        return ModBlock.createItemlessBlock(name, supplier, null);
    }

    public static <B extends Block> RegistryObject<Block> createItemlessBlock(String name, Supplier<? extends B> supplier, @Nullable String renderType) {
        RegistryObject block = BLOCKS.register(name, supplier);
        if (renderType != null) {
            RENDER_TYPE_DATA.add((Pair<RegistryObject<Block>, String>)new Pair((Object)block, (Object)renderType));
        }
        return block;
    }

    public static void registerRendering() {
        for (Pair<RegistryObject<Block>, String> i : RENDER_TYPE_DATA) {
            RenderType j = RenderType.m_110463_();
            if (Objects.equals(i.getSecond(), "cutout")) {
                j = RenderType.m_110463_();
            } else if (Objects.equals(i.getSecond(), "translucent")) {
                j = RenderType.m_110466_();
            }
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)((RegistryObject)i.getFirst()).get()), (RenderType)j);
        }
    }

    public static void registerBlockColors() {
        BlockColors colors = Minecraft.m_91087_().m_91298_();
        BlockColor grassColor = (state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)worldIn, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0);
        colors.m_92589_(grassColor, new Block[]{(Block)YARROW.get()});
        colors.m_92589_(grassColor, new Block[]{(Block)JUNEGRASS.get()});
    }
}

